/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/


package cnrg.itx.datax.jaudio;

/**
 * The interface for an internal queue element.  By extending this interface,
 * objects pushed on the queue are placed directly on the queue and don't need to
 * have a "new" element made for them.
 */
class QueueElement
{
	private Object		mObj   = null;
	private QueueElement mNext = null;

	public void SetObject(Object o)
	{
		mObj = o;
	}
	public void SetNext(QueueElement next)
	{
		mNext = next;
	}
	public Object GetObject()
	{
		return mObj;
	}
	public QueueElement GetNext()
	{
		return mNext;
	}
}
